function [x,dx]=sinespace(x1,x2,N,alfa1,alfa2)
% [x,dx]=sinespace(x1,x2,N,alfa1 [,alfa2])
% sinespace is family of the Matlab standard functions linspace and logspace
% it is meant to facilitate grids with variable distances between lines. It
% uses the sine function to generate grid distances using alfa1 and
% optionally alfa2 in radians to condition the sine function on the end
% points x1 and x2, while N is the number of grid lines including x1 and x2
% sinespace(x1,x2,N,alfa) is equivalent to sinespae(x1,x2,N, 0,alfa)
%
% TO 100214
%
if nargin==4, alfa2=alfa1; alfa1=0; end

L=x2-x1;

u=sin(alfa1+(alfa2-alfa1)*(1:N-0.5)/N); % compute alfa for dx

dx=L*u/sum(u);     % match distances to total distance

x=[x1 x1+cumsum(dx)]; x(end)=x2; dx=abs(dx);

